/*
 * Decompiled with CFR 0.152.
 */
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import javax.media.opengl.GL;
import processing.core.PApplet;
import processing.core.PFont;
import processing.opengl.PGraphicsOpenGL;

public class voxelflowabrot
extends PApplet {
    voltron volt;
    final int MINITER = 200;
    final int MAXITER = 1000;
    final float p = 2.0f;
    final int white = this.color(255);
    float[][] pts = new float[1001][3];
    int count = 0;
    float x;
    float y;
    float z;
    PFont font;
    boolean needRefresh = false;

    public void setup() {
        this.size(1200, 800, "processing.opengl.PGraphicsOpenGL");
        this.frameRate(1000.0f);
        this.background(0);
        this.translate(this.width / 2, this.height / 2);
        this.stroke(255);
        this.font = this.loadFont("Arial-Black-12.vlw");
        this.volt = new voltron(this);
    }

    public void draw() {
        this.compute();
        this.background(0);
        this.translate(this.width / 2, this.height / 2);
        this.fill(255, 80.0f);
        this.textFont(this.font, 12.0f);
        this.text(" Over " + this.volt.getArraySize() / 1000 / 3 / 2 + "K points - FPS : " + this.frameRate, -(this.width / 2), this.height - (this.height / 2 + 15));
        this.pushMatrix();
        this.rotateY(voxelflowabrot.radians((float)((float)this.frameCount * (float)Math.PI / 20.0f)));
        this.pushMatrix();
        this.volt.plotVox("points", 1.0f);
        this.popMatrix();
        this.popMatrix();
        this.needRefresh = false;
    }

    public void compute() {
        while (!this.needRefresh) {
            this.x = this.random(-2.0f, 2.0f);
            this.y = this.random(-2.0f, 2.0f);
            this.z = this.random(-2.0f, 2.0f);
            int n = 0;
            float f = 0.0f;
            float f2 = this.x;
            float f3 = this.y;
            float f4 = this.z;
            f = voxelflowabrot.sqrt((float)(this.x * this.x + this.y * this.y + this.z * this.z));
            float f5 = voxelflowabrot.atan((float)(this.y / this.x)) * 2.0f;
            float f6 = voxelflowabrot.asin((float)(this.z / f)) * 2.0f;
            while (n < 1000 && f < 2.0f) {
                float f7 = voxelflowabrot.pow((float)f, (float)2.0f);
                f5 = voxelflowabrot.atan((float)(f3 / f2)) * 2.0f;
                f6 = voxelflowabrot.asin((float)(f4 / f)) * 2.0f;
                f2 = f7 * voxelflowabrot.cos((float)f6) * voxelflowabrot.cos((float)f5) + this.x;
                f3 = f7 * voxelflowabrot.cos((float)f6) * voxelflowabrot.sin((float)f5) + this.y;
                f4 = f7 * voxelflowabrot.sin((float)f6) + this.z;
                this.pts[n][0] = f2;
                this.pts[n][1] = f3;
                this.pts[n][2] = f4;
                f = voxelflowabrot.sqrt((float)(f2 * f2 + f3 * f3 + f4 * f4));
                ++n;
            }
            if (!(f > 2.0f) || n <= 200) continue;
            int n2 = 200;
            while (n2 < n) {
                if (this.pts[n2][0] * this.pts[n2][0] + this.pts[n2][1] * this.pts[n2][1] + this.pts[n2][2] * this.pts[n2][2] < 2.0f) {
                    this.volt.addPoint(this.pts[n2][0] * 350.0f, this.pts[n2][1] * 350.0f, this.pts[n2][2] * 350.0f, voxelflowabrot.abs((float)this.pts[n2][0]), voxelflowabrot.abs((float)this.pts[n2][1]), voxelflowabrot.abs((float)this.pts[n2][2]), 0.2f);
                    this.volt.addPoint(this.pts[n2][0] * 350.0f, this.pts[n2][1] * 350.0f, -this.pts[n2][2] * 350.0f, voxelflowabrot.abs((float)this.pts[n2][0]), voxelflowabrot.abs((float)this.pts[n2][1]), voxelflowabrot.abs((float)this.pts[n2][2]), 0.2f);
                    this.volt.addPoint(this.pts[n2][0] * 350.0f, -this.pts[n2][1] * 350.0f, this.pts[n2][2] * 350.0f, voxelflowabrot.abs((float)this.pts[n2][0]), voxelflowabrot.abs((float)this.pts[n2][1]), voxelflowabrot.abs((float)this.pts[n2][2]), 0.2f);
                    this.volt.addPoint(this.pts[n2][0] * 350.0f, -this.pts[n2][1] * 350.0f, -this.pts[n2][2] * 350.0f, voxelflowabrot.abs((float)this.pts[n2][0]), voxelflowabrot.abs((float)this.pts[n2][1]), voxelflowabrot.abs((float)this.pts[n2][2]), 0.2f);
                    this.needRefresh = true;
                }
                ++n2;
            }
        }
    }

    public static void main(String[] stringArray) {
        PApplet.main((String[])new String[]{"--bgcolor=#F0F0F0", "voxelflowabrot"});
    }

    public class voltron {
        PApplet p;
        int w;
        int h;
        int d;
        int i;
        int j;
        int k;
        byte[] data;
        FloatBuffer v;
        FloatBuffer c;
        float[] points;
        int numPoints;
        float[] cols;
        boolean updated;
        int sectionstate = 0;
        GL gl;
        int startX;
        int startY;
        int startZ;
        int endX;
        int endY;
        int endZ;
        float alphadepth = 1.0f;
        float threshold = 0.0f;
        String DRAWMODE = "COLORIZE";

        public voltron(PApplet pApplet) {
            if (!(pApplet.g instanceof PGraphicsOpenGL)) {
                throw new RuntimeException("**voltron** > This library requires OpenGL");
            }
            this.p = pApplet;
            this.updated = false;
            this.points = new float[30000];
            this.numPoints = 0;
            this.cols = new float[40000];
            System.out.println("**voltron** > VOLTRON v1.1.0 by Joey Scully - ker2x edition");
        }

        public void loadVox(String string, int n, int n2, int n3) {
            System.out.println("**voltron** > LOADING " + string);
            this.w = n;
            this.h = n2;
            this.d = n3;
            this.startX = 0;
            this.startY = 0;
            this.startZ = 0;
            this.endX = n;
            this.endY = n2;
            this.endZ = n3;
            this.data = this.p.loadBytes(string);
            System.out.println("**voltron** > load " + string + " COMPLETE");
        }

        public int getVox(int n, int n2, int n3) {
            return n >= 0 && n < this.w && n2 >= 0 && n2 < this.h && n3 >= 0 && n3 < this.d ? this.data[(n3 << 16) + (n2 << 8) + n] : 0;
        }

        public void setDimens(int n, int n2, int n3, int n4, int n5, int n6) {
            this.startX = n;
            this.startY = n2;
            this.startZ = n3;
            this.endX = n4;
            this.endY = n5;
            this.endZ = n6;
        }

        public void setDrawmode(float f, float f2, String string) {
            this.DRAWMODE = string;
            this.alphadepth = f / 1000.0f;
            this.threshold = f2;
            if (this.DRAWMODE != "ALPHASCALE" && this.DRAWMODE != "COLORIZE" && this.DRAWMODE != "THRESHOLD") {
                throw new RuntimeException("**voltron** > DRAWMODE Variable must specify ALPHASCALE, COLORIZE or THRESHOLD");
            }
        }

        public void setVox(int n, float f, int n2) {
            float f2 = 255.0f;
            float f3 = 255.0f;
            float f4 = 255.0f;
            float f5 = 255.0f;
            if (n2 == 1) {
                this.i = this.startZ;
                while (this.i < this.endZ) {
                    this.j = this.startX;
                    while (this.j < this.endX) {
                        this.k = this.startY;
                        while (this.k < this.endY) {
                            if (this.DRAWMODE == "ALPHASCALE") {
                                f2 = (float)this.getVox(this.i, this.j, this.k) * this.alphadepth;
                            }
                            if (this.DRAWMODE == "THRESHOLD") {
                                f2 = (float)this.getVox(this.i, this.j, this.k) * this.alphadepth;
                                f2 = f2 > this.threshold ? (f2 += f2) : 0.0f;
                            }
                            if (this.DRAWMODE == "COLORIZE") {
                                f2 = (float)this.getVox(this.i, this.j, this.k) * this.alphadepth;
                                f3 = 0.0f;
                                f4 = 0.0f;
                                f5 = 0.0f;
                                if (f2 > 0.09f) {
                                    f3 = 0.0f;
                                    f4 = 255.0f / f2;
                                    f5 = 255.0f / f2;
                                }
                                if (f2 > 0.07f && f2 < 0.09f) {
                                    f3 = 255.0f / f2;
                                    f4 = 255.0f / f2;
                                    f5 = 255.0f / f2;
                                }
                                if (f2 > 0.06f && f2 < 0.07f) {
                                    f3 = 255.0f / f2;
                                    f4 = 165.0f / f2;
                                    f5 = 0.0f;
                                }
                                if (f2 > 0.03f && f2 < 0.06f) {
                                    f3 = 255.0f / f2;
                                    f4 = 0.0f;
                                    f5 = 0.0f;
                                }
                                if (f2 > 0.01f && f2 < 0.03f) {
                                    f4 = 255.0f / f2;
                                }
                                if (f2 > 0.001f && f2 < 0.01f) {
                                    f4 = 50.0f / f2;
                                }
                            }
                            this.addPoint((float)this.i * f - (float)(this.w / 2), (float)this.j * f - (float)(this.w / 2), (float)this.k * f - (float)(this.w / 2), f3, f4, f5, f2);
                            this.k += n;
                        }
                        this.j += n;
                    }
                    this.i += n;
                }
            }
            n2 = 0;
            System.out.println("**voltron** > All Points Set");
        }

        public void addPoint(float f, float f2, float f3, float f4, float f5, float f6, float f7) {
            this.updated = true;
            if (this.numPoints + 1 == this.points.length / 3) {
                int n = this.points.length;
                float[] fArray = new float[n *= 2];
                System.arraycopy(this.points, 0, fArray, 0, this.points.length);
                this.points = null;
                this.points = fArray;
                n = this.cols.length;
                fArray = new float[n *= 2];
                System.arraycopy(this.cols, 0, fArray, 0, this.cols.length);
                this.cols = null;
                this.cols = fArray;
                System.gc();
            }
            this.points[this.numPoints * 3] = f;
            this.points[this.numPoints * 3 + 1] = f2;
            this.points[this.numPoints * 3 + 2] = f3;
            this.cols[this.numPoints * 4] = f4;
            this.cols[this.numPoints * 4 + 1] = f5;
            this.cols[this.numPoints * 4 + 2] = f6;
            this.cols[this.numPoints * 4 + 3] = f7;
            ++this.numPoints;
        }

        public void plotVox(String string, float f) {
            if (this.updated) {
                this.v = ByteBuffer.allocateDirect(12 * this.numPoints).order(ByteOrder.nativeOrder()).asFloatBuffer();
                this.v.put(this.points, 0, 3 * this.numPoints);
                this.v.rewind();
                this.c = ByteBuffer.allocateDirect(16 * this.numPoints).order(ByteOrder.nativeOrder()).asFloatBuffer();
                this.c.put(this.cols, 0, 4 * this.numPoints);
                this.c.rewind();
                this.updated = false;
            }
            this.gl = ((PGraphicsOpenGL)this.p.g).beginGL();
            this.gl.glEnable(3042);
            this.gl.glBlendFunc(770, 1);
            this.gl.glDepthMask(false);
            this.gl.glEnable(2832);
            this.gl.glHint(3153, 4354);
            this.gl.glPointSize(f);
            this.gl.glEnableClientState(32884);
            this.gl.glEnableClientState(32886);
            this.gl.glVertexPointer(3, 5126, 0, (Buffer)this.v);
            this.gl.glColorPointer(4, 5126, 0, (Buffer)this.c);
            if (string == "points") {
                this.gl.glPointSize(f);
                this.gl.glDrawArrays(0, 0, this.numPoints);
            }
            this.gl.glDisableClientState(32886);
            this.gl.glDisableClientState(32884);
            ((PGraphicsOpenGL)this.p.g).endGL();
        }

        public void plotVox(String string) {
            if (this.updated) {
                this.v = ByteBuffer.allocateDirect(12 * this.numPoints).order(ByteOrder.nativeOrder()).asFloatBuffer();
                this.v.put(this.points, 0, 3 * this.numPoints);
                this.v.rewind();
                this.c = ByteBuffer.allocateDirect(16 * this.numPoints).order(ByteOrder.nativeOrder()).asFloatBuffer();
                this.c.put(this.cols, 0, 4 * this.numPoints);
                this.c.rewind();
                this.updated = false;
            }
            this.gl = ((PGraphicsOpenGL)this.p.g).beginGL();
            this.gl.glEnable(3042);
            this.gl.glBlendFunc(770, 1);
            this.gl.glDepthMask(false);
            this.gl.glEnable(2832);
            this.gl.glHint(3153, 4354);
            this.gl.glEnableClientState(32884);
            this.gl.glEnableClientState(32886);
            this.gl.glVertexPointer(3, 5126, 0, (Buffer)this.v);
            this.gl.glColorPointer(4, 5126, 0, (Buffer)this.c);
            if (string == "poly") {
                this.gl.glDrawArrays(9, 0, this.numPoints);
            }
            if (string == "trifan") {
                this.gl.glDrawArrays(6, 0, this.numPoints);
            }
            if (string == "tri") {
                this.gl.glDrawArrays(4, 0, this.numPoints);
            }
            if (string == "quads") {
                this.gl.glDrawArrays(7, 0, this.numPoints);
            }
            if (string == "quadstrip") {
                this.gl.glDrawArrays(8, 0, this.numPoints);
            }
            if (string == "lineloop") {
                this.gl.glDrawArrays(2, 0, this.numPoints);
            }
            if (string == "linestrip") {
                this.gl.glDrawArrays(3, 0, this.numPoints);
            }
            if (string == "lines") {
                this.gl.glDrawArrays(1, 0, this.numPoints);
            }
            if (string == "lineadj") {
                this.gl.glDrawArrays(10, 0, this.numPoints);
            }
            this.gl.glDisableClientState(32886);
            this.gl.glDisableClientState(32884);
            ((PGraphicsOpenGL)this.p.g).endGL();
        }

        public void clearVox() {
            this.v.clear();
            this.c.clear();
            this.cols = null;
            this.points = null;
            this.updated = false;
            this.numPoints = 0;
            this.points = new float[30000];
            this.cols = new float[40000];
            System.out.println("**voltron** > All Points and Arrays CLEARED");
        }

        public void sectionEnable(int n, int n2, int n3, float f) {
            if (n == 1) {
                this.gl = ((PGraphicsOpenGL)this.p.g).beginGL();
                this.gl.glEnable(3042);
                this.gl.glBlendFunc(770, 1);
                this.gl.glEnable(2832);
                this.gl.glHint(3153, 4354);
                this.gl.glPointSize(f);
                this.gl.glEnableClientState(32884);
                this.gl.glEnableClientState(32886);
                this.gl.glVertexPointer(3, 5126, 0, (Buffer)this.v);
                this.gl.glColorPointer(4, 5126, 0, (Buffer)this.c);
                this.gl.glDrawArrays(0, this.numPoints / this.h * n2, this.h * this.w / 4 * n3);
                this.gl.glDisableClientState(32886);
                this.gl.glDisableClientState(32884);
                ((PGraphicsOpenGL)this.p.g).endGL();
                n = 0;
            }
        }

        public void plotVoxrange(int n, int n2, int n3, float f) {
            if (n == 1) {
                if (this.updated) {
                    this.v = ByteBuffer.allocateDirect(12 * this.numPoints).order(ByteOrder.nativeOrder()).asFloatBuffer();
                    this.v.put(this.points, 0, 3 * this.numPoints);
                    this.v.rewind();
                    this.c = ByteBuffer.allocateDirect(16 * this.numPoints).order(ByteOrder.nativeOrder()).asFloatBuffer();
                    this.c.put(this.cols, 0, 4 * this.numPoints);
                    this.c.rewind();
                    this.updated = false;
                }
                this.gl = ((PGraphicsOpenGL)this.p.g).beginGL();
                this.gl.glEnable(3042);
                this.gl.glBlendFunc(770, 1);
                this.gl.glEnable(2832);
                this.gl.glHint(3153, 4354);
                this.gl.glPointSize(f);
                this.gl.glEnableClientState(32884);
                this.gl.glEnableClientState(32886);
                this.gl.glVertexPointer(3, 5126, 0, (Buffer)this.v);
                this.gl.glColorPointer(4, 5126, 0, (Buffer)this.c);
                this.gl.glDrawArrays(0, n2, n3);
                this.gl.glDisableClientState(32886);
                this.gl.glDisableClientState(32884);
                ((PGraphicsOpenGL)this.p.g).endGL();
                n = 0;
            }
        }

        public int getArraySize() {
            return this.points.length;
        }
    }
}

